<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"spedizioni","status"=>250);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="spedizioni") {
        $cercaSpedizioni = $_GET["cerca"];
        $parametriRicerca = array("nome"=>filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES));
    }
    else {
        $cercaSpedizioni = "";
        $parametriRicerca = array();
    }
    
    $parametri = array("tabella"=>"geecEc_metodiSpedizione", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
    <h4 class="mb-4 title">Spedizioni</h4>
    
    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <a class="nav-link active" data-toggle="tab" href="#metodiSpedizione" role="tab" aria-controls="metodiSpedizione" aria-selected="true">Metodi di spedizione</a>
        </li>
        <li class="nav-item" role="presentation">
            <a class="nav-link" data-toggle="tab" href="#areeGeografiche" role="tab" aria-controls="areeGeografiche" aria-selected="true">Aree geografiche</a>
        </li>
        <li class="nav-item" role="presentation">
            <a class="nav-link" data-toggle="tab" href="#zoneDisagiate" role="tab" aria-controls="zoneDisagiate" aria-selected="true">Zone disagiate</a>
        </li>
    </ul>
    
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade  show active" id="metodiSpedizione" role="tabpanel" aria-labelledby="metodiSpedizione">
            <a href="creaSpedizione.php" class="btn btn-sm btn-primary" >
                Crea spedizione<i class="fas fa-plus ml-2"></i>
            </a>
            <hr> 

            <div class="d-flex justify-content-between mb-3">
                <?php
                    $ricerca->stampaSelectNumeroElementi($cercaSpedizioni,$campiAggiuntiviRicerca);
                    $ricerca->stampaFormRicerca($cercaSpedizioni,$campiAggiuntiviRicerca);
                ?>
            </div>
            <div class="table-responsive table-sm">
                <?php

                    if(isset($_GET["pag"])) {
                        $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
                    }
                    else {
                        $ris = $ricerca->eseguiRicerca(1,"OR");
                    }

                    $colonne = array("ID","Nome","Costo €","Descrizione","Disponibile","");
                    $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                    $tabella->setTipo("normale");
                    while($spedizione = $ris->fetch_assoc()) {
                        $nomeEscape    = filter_var($spedizione["nome"],FILTER_SANITIZE_ADD_SLASHES);
                        $azioni = array("modifica"=>"creaSpedizione.php?id={$spedizione["id"]}","elimina"=>"apriPopupEliminaSpedizione({$spedizione["id"]},'$nomeEscape')");

                        $tabella->aggiungiNuovaRiga(array($spedizione["id"],"<a href=\"creaSpedizione.php?id={$spedizione["id"]}\"><b>".$nomeEscape."</b></a>",$spedizione["costo"],$spedizione["descrizione"],$spedizione["disponibile"]),$azioni);
                    }
                    $tabella->stampa("rigaSpedizione",0);
                    $ricerca->stampaPaginazione(true,"index.php");
                ?>
            </div>  
        </div>
        
        <div class="tab-pane fade show" id="areeGeografiche" role="tabpanel" aria-labelledby="areeGeografiche">
            <div class="row">
                <div class="col-12 mb-3">
                    Se le aree geografiche sono attive i clienti dovranno scegliere la nazione tra quelle in elenco e verranno mostrati i metodi di spedizione compatibili con quell'area geografica
                </div>
                
                <div class="col-md-3 form-group">
                    <label class="d-block">Attiva aree geografiche</label>
                    <input type="checkbox" class="js-switch" id="attivaAreeGeografiche" value="si" <?php echo(($impostazioniEcommerce["attivaAreeGeografiche"]=="si") ? "checked":"") ?>>
                </div>
                
                <div class="col-md-9 form-group">
                    <label class="d-block">Nazioni da visualizzare</label>
                    <textarea id="nazioniDaVisualizzare" class="form-control" ><?php echo $impostazioniEcommerce["nazioniDaVisualizzare"] ?></textarea>
                    <small class="text-muted">Inserisci le nazioni appartenenti a questa area geografica separate da virgola</small>
                </div>
                
                <div class="col-12">
                    <hr>
                    <button type="button" onclick="modificaImpostazioniAreeGeografiche()" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
                </div>
                
                <div class="w-100 mt-5"></div>
                
                <div class="col-lg-4 col-xl-3">
                    <form>
                        <div class="mb-4 add-box">
                            <h6 class="mb-3"> Aggiungi area geografica</h6>
                            <div class="options-box">

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nome</label>
                                    <input type="text" class="form-control" id="nomeAreaGeografica" placeholder="Titolo">
                                </div>

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nazioni appartenenti</label>
                                    <textarea class="form-control" id="nazioniAppartenenti"></textarea>
                                </div>
                                
                                <button type="button" class="btn btn-primary float-right" value="Aggiungi"  onclick="creaAreaGeografica()"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-lg-8 col-xl-9 mb-4 gerarchia-menu" >
                    <div id="divAreeGeografiche" class="row">
                        <?php stampaAreeGeografiche($geecomDb) ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="tab-pane fade show" id="zoneDisagiate" role="tabpanel" aria-labelledby="zoneDisagiate">
            <div class="row">
                <div class="col-lg-4 col-xl-3">
                    <form>
                        <div class="mb-4 add-box">
                            <h6 class="mb-3"> Aggiungi zona disagiata</h6>
                            <div class="options-box">

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nome</label>
                                    <input type="text" class="form-control" id="nomeZonaDisagiata" placeholder="Titolo">
                                </div>

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">CAP inizio</label>
                                    <input type="text" class="form-control" id="CAPInizioZonaDisagiata" placeholder="CAP inizio">
                                </div>
                                
                                <div class="form-group">
                                    <label for="nome-voce-menu-1">CAP fine</label>
                                    <input type="text" class="form-control" id="CAPFineZonaDisagiata" placeholder="CAP fine">
                                </div>
                                
                                <button type="button" class="btn btn-primary float-right" value="Aggiungi"  onclick="creaZonaDisagiata()"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                    <div id="divZoneDisagiate" class="row">
                        <?php stampaZoneDisagiate($geecomDb) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>